IF OBJECT_ID('EST_PARAM_COMPRAS_PERFIL_EST_PROD') IS NULL 
begin
CREATE TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD](
	[CD_PERFIL_PROD] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_PERFIL_DEMOGRAFICO] [int] NOT NULL,
	[CD_PERFIL_TAMANHO] [int] NOT NULL,
	[CD_PERFIL_FATURAMENTO] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
 CONSTRAINT [PK_EST_PARAM_COMPRAS_PERFIL_EST_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_PERFIL_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [IX_EST_PARAM_COMPRAS_PERFIL_EST_PROD] UNIQUE NONCLUSTERED 
(
	[CD_EMP] ASC,
	[CD_PROD] ASC,
	[CD_PERFIL_DEMOGRAFICO] ASC,
	[CD_PERFIL_TAMANHO] ASC,
	[CD_PERFIL_FATURAMENTO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_PERFIL_DEMOGRAFICO]  DEFAULT ((0)) FOR [CD_PERFIL_DEMOGRAFICO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_PERFIL_TAMANHO]  DEFAULT ((0)) FOR [CD_PERFIL_TAMANHO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_PERFIL_FATURAMENTO]  DEFAULT ((0)) FOR [CD_PERFIL_FATURAMENTO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_PERFIL_EST_PROD_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_DEMOGRAFICO] FOREIGN KEY([CD_PERFIL_DEMOGRAFICO])
REFERENCES [dbo].[EST_PARAM_COMPRAS_PERFIL_DEMOGRAFICO] ([CD_PERFIL_DEMOGRAFICO])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_DEMOGRAFICO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_FATURAMENTO] FOREIGN KEY([CD_PERFIL_FATURAMENTO])
REFERENCES [dbo].[EST_PARAM_COMPRAS_PERFIL_FATURAMENTO] ([CD_PERFIL_FATURAMENTO])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_FATURAMENTO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_TAMANHO] FOREIGN KEY([CD_PERFIL_TAMANHO])
REFERENCES [dbo].[EST_PARAM_COMPRAS_PERFIL_TAMANHO] ([CD_PERFIL_TAMANHO])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PARAM_COMPRAS_PERFIL_TAMANHO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_PERFIL_EST_PROD] CHECK CONSTRAINT [FK_EST_PARAM_COMPRAS_PERFIL_EST_PROD_EST_PROD]
end